<?php
// Simple Proxy to bypass CORS for Cloudron API calls
// Usage: POST JSON { "url": "...", "method": "GET|POST", "headers": {...}, "data": {...} }

header('Content-Type: application/json');

// Get raw input
$input = file_get_contents('php://input');
// FIX: Decode as Object (not Array) to preserve empty objects {} vs empty arrays []
$request = json_decode($input);

if (!$request || !isset($request->url)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid request. "url" is required.']);
    exit;
}

$url = $request->url;
$method = $request->method ?? 'GET';
$headers = $request->headers ?? [];
$data = $request->data ?? null;

// Prepare cURL
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);

// Prepare Headers
$curlHeaders = [];
foreach ($headers as $key => $value) {
    $curlHeaders[] = "$key: $value";
}
$curlHeaders[] = 'Content-Type: application/json'; // Ensure JSON content type
curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeaders);

// Prepare Body
if ($data && ($method === 'POST' || $method === 'PUT')) {
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
}

// Ignore SSL verification if needed (mimicking the Node.js 'rejectUnauthorized: false')
// WARNING: Not recommended for production, but needed for self-signed Cloudrons
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

// Execute
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

curl_close($ch);

// Return result
http_response_code($httpCode);
if ($error) {
    echo json_encode(['error' => "Proxy Error: $error"]);
} else {
    echo $response;
}
?>